
# WG9914D STM32‑HAL 驱动库使用说明（v 1.0.2）

> **适用芯片**：WG9914D UART⇄GPIB 转换器  
> **适用 MCU**：STM32F103 /F4及其他 单片机  
> **作者**：WWKJ FxMan   **日期**：2025‑05‑28  

---

## 1 文件结构

| 文件 | 功能 |
|------|------|
| **WG9914D.h** | 驱动对外 API（极简 3 函数） |
| **WG9914D.c** | 驱动实现（大小写敏感、子串匹配、支持“只发不等”） |
| **WG9914D_使用说明.md** | 当前文档 |

---

## 2 快速集成

1. **CubeMX 配置**  
   * 使能 USART1（或任意串口）为 *Asynchronous*  
   * 勾选 USART 全局中断  
   * 系统时钟、GPIO 按项目需求配置  

2. **复制驱动文件**  
   ```
   WG9914D.h
   WG9914D.c
   ```

3. **实现板级接口**

   ```c
   /* 串口发送（阻塞或 DMA 均可） */
   int32_t Board_UART_Tx(const uint8_t *buf, uint16_t len);

   /* 精确 1 ms 延时 */
   void Board_Delay1ms(void);   /* 例如 HAL_Delay(1) 或 osDelay(1) */
   ```

4. **初始化驱动**

   ```c
   WG9914D_Init(Board_UART_Tx,
                Board_Delay1ms,
                "WG9914D,WWKJ,SN0001,V1.0.2");

   /* 启动单字节中断接收 */
   HAL_UART_Receive_IT(&huart1, &rx_byte, 1);
   ```

5. **在 RX 回调喂数据**

   ```c
   void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
   {
       if (huart == &huart1)
       {
           WG9914D_InputByte(rx_byte);           /* 交给驱动解析 */
           HAL_UART_Receive_IT(&huart1, &rx_byte, 1); /* 再收下一字节 */
       }
   }
   ```

6. **发送指令并（可选）等待回显**

   ```c
   /* 只发送，不等待 */
   WG9914D_SendLineWait("++info\n", NULL, NULL, 0);
   
   /* 改 GPIB 地址为 23，500 ms 内等待 “#A 23” 回显 */
   WG9914D_SendLineWait("#A 23\n", "#A 23", NULL, 500);
   ```

---

## 3 API 速查

| 函数 | 说明 |
|------|------|
| `WG9914D_Init(tx, delay1ms, idn)` | 初始化驱动（必须先调用） |
| `WG9914D_InputByte(ch)` | 每收到 1 字节立即调用 |
| `WG9914D_SendLineWait(cmd, exp1, exp2, timeout)` | 发送一行并阻塞等待回显；若 `exp1/exp2` 均为空或 `timeout == 0` 则仅发送立即返回 `true` |

* **大小写敏感**：`#A 23` ≠ `#a 23`  
* **子串匹配**：只要回显中包含期望子串即成功  

---

## 4 常用指令

| 功能 | 指令示例（末尾需 `\n`） | 典型回显 |
|------|-------------------------|----------|
| 查询固件信息 | `++info` | `GPIB UART WGTUDEV V1.21` |
| 查询 ID | `*IDN?` | 初始化传入的 `idn` 字符串 |
| 设置 GPIB 地址 | `#A <addr>` | `#A <addr>` |
| 设置串口波特率/校验位 | `#U <baud> <parity>`<br>`parity: 0=无 1=奇 2=偶` | `#U <baud> <parity>` 或 `#U OK` |
| 软复位 | `#R` | `#R` |

---

## 5 常见问题

| 现象 | 解决方案 |
|------|----------|
| 无回显或超时 | 检查 RX 中断是否逐字节调用 `WG9914D_InputByte()`；确认指令末尾带 `\n` |
| 修改波特率后通信中断 | 先用旧波特率发送 `#U` 并收到回显 OK，再在 MCU 与 PC 同步切到新波特率 |
| 发送 `*IDN?` 无响应 | 波特率不一致或初始化 `idn` 字符串为空 |

---

## 6 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 1.0.0 | 2025‑01‑20 | 极简 API 初版 |
| 1.0.1 | 2025‑03‑27 | 子串匹配；支持“只发不等” |
| **1.0.2** | 2025‑05‑28 | 搜索缓冲清空；中文说明 |

---

如需技术支持，请联系 **xudarong@wwzhyun.cn**  
© 2025 物唯科技，保留所有权利。可免费用于商业项目，但请保留版权信息。
